@extends('admin.layouts.app')

@section('title', 'Asignacion Academica por Profesor y Asignatura')
@section('page_title', 'Asignacion Academica por Profesor y Asignatura')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:18px 14px 28px; }
        .legacy-title { text-align:center; color:#00607f; font-size:38px; margin:8px 0 18px; font-weight:800; }
        .legacy-form { max-width: 720px; margin: 0 auto; }
        .legacy-form .row {
            display:grid;
            grid-template-columns: 130px 1fr 16px;
            gap:8px;
            align-items:center;
            margin-bottom:10px;
        }
        .legacy-form label { font-weight:700; color:#111; font-size:15px; }
        .legacy-form select { background:#d9e7e7; border:1px solid #08708e; border-radius:0; height:30px; padding:4px 8px; width:100%; }
        .req { color:#d98b00; font-weight:700; }
        .section-title { text-align:center; letter-spacing:6px; color:#0d6284; font-size:28px; font-weight:800; margin:14px 0 8px; }
        .help { max-width: 760px; margin: 0 auto 8px; }
        .table-box { border:2px solid #0e7a96; background:#fff; max-width:760px; margin:0 auto; }
        .legacy-table { width:100%; border-collapse:collapse; }
        .legacy-table th, .legacy-table td { border:1px solid #95a5ad; padding:5px 6px; font-size:15px; text-align:left; vertical-align:middle; }
        .legacy-table th { background:#d5dddd; font-weight:800; }
        .legacy-table tbody tr:nth-child(even) { background:#ccdbdd; }
        .actions { text-align:center; margin-top:14px; }
        .btn-legacy { background:#d9a10c; border:1px solid #9a7205; color:#fff; font-weight:700; min-width:110px; height:32px; border-radius:6px; cursor:pointer; padding:0 18px; }
        .total { max-width:760px; margin:4px auto 0; text-align:right; font-size:13px; }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Asignación Académica por Profesor y Asignatura</h2>
        @if(session('status'))
            <div style="max-width:760px;margin:0 auto 10px;padding:8px 10px;background:#e7f7ea;border:1px solid #9dd5aa;color:#125323;">{{ session('status') }}</div>
        @endif

        <form class="legacy-form" method="GET" id="filterForm">
            <input type="hidden" name="annio" value="{{ $annio }}">
            <div class="row">
                <label for="profesor">Profesor</label>
                <select id="profesor" name="profesor" onchange="document.getElementById('filterForm').submit()">
                    <option value="">(Seleccione uno)</option>
                    @foreach($profesores as $p)
                        @php
                            $fullName = trim(($p->nombres ?? '') . ' ' . ($p->apellido1 ?? '') . ' ' . ($p->apellido2 ?? ''));
                        @endphp
                        <option value="{{ (int) $p->id }}" @selected((string)$profesor === (string)$p->id)>{{ $fullName }}</option>
                    @endforeach
                </select>
                <span class="req">*</span>
            </div>
            <div class="row">
                <label for="asignatura">Asignatura</label>
                <select id="asignatura" name="asignatura" onchange="document.getElementById('filterForm').submit()">
                    <option value="">(Seleccione uno)</option>
                    @foreach($asignaturas as $a)
                        <option value="{{ (int) $a->id }}" @selected((string)$asignatura === (string)$a->id)>{{ mb_strtoupper((string) $a->nombre) }}</option>
                    @endforeach
                </select>
                <span class="req">*</span>
            </div>
        </form>

        @if($profesor !== '' && $asignatura !== '')
            <h3 class="section-title">CURSOS</h3>
            <div class="help">Seleccione los <strong>cursos</strong> en los que el <strong>profesor</strong> seleccionado dicta la <strong>asignatura</strong> seleccionada:</div>

            <form method="POST" action="{{ route('admin.academia.asignacion.profesor_asignatura.save') }}">
                @csrf
                <input type="hidden" name="annio" value="{{ $annio }}">
                <input type="hidden" name="profesor" value="{{ $profesor }}">
                <input type="hidden" name="asignatura" value="{{ $asignatura }}">

                <div class="table-box">
                    <table class="legacy-table ui-table">
                        <thead>
                            <tr>
                                <th style="width:34px;"><input type="checkbox" id="all_courses"></th>
                                <th>Curso</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($courses as $c)
                                <tr>
                                    <td><input type="checkbox" name="salones[]" value="{{ (int) $c->id }}" @checked(in_array((int) $c->id, $selectedSalonIds, true))></td>
                                    <td>{{ $c->nombre }}</td>
                                </tr>
                            @empty
                                <tr><td colspan="2">No hay cursos asociados a esta asignatura.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="total ui-total">Total registros: {{ $courses->count() }}</div>

                <div class="actions">
                    <button type="submit" class="btn-legacy">Guardar</button>
                </div>
            </form>
        @endif
    </div>

    <script>
        (function () {
            const all = document.getElementById('all_courses');
            if (!all) return;
            const boxes = Array.from(document.querySelectorAll('input[name="salones[]"]'));
            const sync = () => all.checked = boxes.length > 0 && boxes.every(b => b.checked);
            all.addEventListener('change', () => boxes.forEach(b => b.checked = all.checked));
            boxes.forEach(b => b.addEventListener('change', sync));
            sync();
        })();
    </script>
@endsection

