@extends('admin.layouts.app')

@section('title', 'Detalle de Asignatura')
@section('page_title', 'Detalle de Asignatura')

@section('content')
    <style>
        .detail-wrap { background:#efefef; border:1px solid #cdd5db; padding:14px; max-width: 980px; margin: 0 auto; }
        .h-main { text-align:center; color:#035f7b; margin:8px 0 12px; font-size:36px; font-weight:800; }
        .box { border:2px solid #0f708e; background:#fff; }
        .box-head { background:#0d6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .box-body { padding:12px; }
        .req { text-align:right; color:#d98b00; font-style:italic; }
        .grid { display:grid; grid-template-columns: 1.4fr 0.8fr; gap:14px; margin-bottom:12px; }
        .field label { display:block; font-weight:700; font-size:14px; margin-bottom:2px; }
        .field input, .field select { width:100%; height:30px; border:1px solid #0a7391; background:#d9e7e7; padding:4px 8px; }
        .check-row { margin-top:6px; display:flex; gap:16px; align-items:center; }
        .section-title { text-align:center; letter-spacing:6px; color:#0d6284; font-size:22px; font-weight:800; margin:8px 0 4px; }
        .sub-table { width:60%; min-width:420px; border-collapse:collapse; border:2px solid #0e7a96; background:#fff; }
        .sub-table th, .sub-table td { border:1px solid #95a5ad; padding:5px; font-size:14px; }
        .sub-table th { background:#c8d8d8; text-align:left; font-weight:800; }
        .actions { margin:14px 0 4px; display:flex; justify-content:center; gap:18px; flex-wrap:wrap; }
        .btn-legacy {
            background:#d9a10c; border:1px solid #9a7205; color:#fff; font-weight:700;
            min-width:110px; height:32px; border-radius:6px; cursor:pointer; padding:0 18px; text-decoration:none;
            display:inline-flex; align-items:center; justify-content:center;
        }
        .btn-danger { background:#b53a3a; border-color:#7f2525; }
    </style>

    <div class="detail-wrap">
        <h2 class="h-main">Detalle de Asignatura</h2>
        @if(session('status'))
            <div style="margin-bottom:10px;padding:8px 10px;background:#e7f7ea;border:1px solid #9dd5aa;color:#125323;">{{ session('status') }}</div>
        @endif
        @if ($errors->any())
            <div style="margin-bottom:10px;padding:8px 10px;background:#fff3f3;border:1px solid #efb0b0;color:#8b1f1f;">
                <ul style="margin:0 0 0 18px;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="box">
            <div class="box-head ui-box-head">Detalle de Asignatura</div>
            <div class="box-body">
                <div class="req">* Requerido</div>
                <form method="POST" action="{{ $isCreate ? route('admin.academia.asignaturas.store') : route('admin.academia.asignaturas.update', ['id' => (int) $asignatura->id]) }}">
                    @csrf
                    <div class="grid">
                        <div>
                            <div class="field">
                                <label>Nombre *</label>
                                <input name="nombre" value="{{ old('nombre', $asignatura->nombre) }}">
                            </div>
                            <div class="field">
                                <label>Abreviatura *</label>
                                <input name="abrev" value="{{ old('abrev', $asignatura->abrev) }}">
                            </div>
                            <div class="field">
                                <label>Área Académica</label>
                                <select name="area_id">
                                    <option value="">(Sin área)</option>
                                    @foreach($areas as $a)
                                        <option value="{{ (int) $a->id }}" @selected((string) old('area_id', $asignatura->area_id) === (string) $a->id)>
                                            {{ mb_strtoupper((string) $a->nombre) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div>
                            <div class="field">
                                <label>Orden</label>
                                <input name="orden" value="{{ old('orden', (int) $asignatura->orden) }}">
                            </div>
                            <div class="check-row">
                                <label><input type="checkbox" name="is_active" value="1" @checked((int) old('is_active', $asignatura->is_active) === 1)> Activa</label>
                            </div>
                            <div class="check-row">
                                <label><input type="checkbox" name="calc_prom" value="1" @checked((int) old('calc_prom', $asignatura->calc_prom) === 1)> Calcula promedio</label>
                            </div>
                        </div>
                    </div>

                    <h3 class="section-title">GRADOS RELACIONADOS</h3>
                    <table class="sub-table">
                        <thead><tr><th>Nombre</th></tr></thead>
                        <tbody>
                        @forelse($grados as $g)
                            <tr><td>{{ mb_strtoupper((string) $g->nombre) }}</td></tr>
                        @empty
                            <tr><td>Sin grados relacionados.</td></tr>
                        @endforelse
                        </tbody>
                    </table>

                    <div class="actions">
                        <button type="submit" class="btn-legacy">Guardar</button>
                        @if(!$isCreate)
                            <button type="submit" form="delete-form" class="btn-legacy btn-danger" onclick="return confirm('Seguro que quieres eliminar esta asignatura?');">Eliminar</button>
                        @endif
                        <a href="{{ route('admin.academia.item', ['item' => 'asignaturas']) }}" class="btn-legacy">Regresar</a>
                    </div>
                </form>
                @if(!$isCreate)
                    <form id="delete-form" method="POST" action="{{ route('admin.academia.asignaturas.delete', ['id' => (int) $asignatura->id]) }}" style="display:none;">
                        @csrf
                    </form>
                @endif
            </div>
        </div>
    </div>
@endsection

