@extends('admin.layouts.app')

@section('title', 'Logros')
@section('page_title', 'Logros')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:14px 10px 20px; }
        .legacy-title { text-align:center; color:#00607f; font-size:39px; font-size:38px; margin:2px 0 12px; font-weight:800; }
        .tools { max-width: 1220px; margin: 0 auto 12px; display:grid; grid-template-columns: 160px 1fr 160px 1fr 110px 120px; gap:10px 8px; align-items:center; }
        .tools label { font-weight:700; font-size:15px; }
        .tools select { width:100%; height:30px; border:1px solid #08708e; background:#d9e7e7; padding:4px 8px; }
        .btn-legacy { background:#d9a10c; border:1px solid #9a7205; color:#fff; font-weight:700; min-width:90px; height:32px; border-radius:6px; cursor:pointer; padding:0 14px; box-shadow:0 2px 3px rgba(0,0,0,.25); }
        .table-box { border:2px solid #0e7a96; background:#fff; max-width:1220px; margin:0 auto; }
        .table-title { background:#0e6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:3px; text-transform:uppercase; display:flex; gap:14px; align-items:center; }
        .tab-link { color:#f2f2f2; text-decoration:underline; font-weight:700; }
        .tab-link.active { color:#ffcf40; }
        .pager-top { margin-left:auto; color:#cfe8f2; font-size:12px; }
        .legacy-table { width:100%; border-collapse:collapse; }
        .legacy-table th, .legacy-table td { border:1px solid #95a5ad; padding:5px 6px; font-size:15px; text-align:left; vertical-align:top; }
        .legacy-table th { background:#d5dddd; font-weight:800; }
        .legacy-table tbody tr:nth-child(even) { background:#ccdbdd; }
        .logro-link { color:#005c83; text-decoration:underline; text-underline-offset:2px; }
        .meta { color:#70808b; font-size:11px; margin-top:6px; line-height:1.2; display:flex; justify-content:space-between; gap:8px; }
        .pager { margin-top:10px; display:flex; justify-content:center; gap:6px; flex-wrap:wrap; }
        .pager a, .pager span {
            border:1px solid #8da0ad; background:#fff; color:#0e2b3d; text-decoration:none;
            padding:4px 9px; border-radius:4px; font-size:13px; line-height:1.2;
        }
        .pager .active { background:#0e6f88; border-color:#0e6f88; color:#fff; font-weight:700; }
        .pager .disabled { opacity:.45; pointer-events:none; }
        @media (max-width: 1100px) {
            .tools { grid-template-columns: 140px 1fr 140px 1fr; }
        }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Logros</h2>

        <form class="tools ui-label" method="GET">
            <input type="hidden" name="estado" value="{{ $estado }}">

            <label for="profesor">Profesor</label>
            <select id="profesor" name="profesor">
                <option value="">(Todos)</option>
                @foreach($profesores as $p)
                    <option value="{{ (int) $p->id }}" @selected((string)$profesor === (string)$p->id)>{{ trim(($p->nombres ?? '').' '.($p->apellido1 ?? '').' '.($p->apellido2 ?? '')) }}</option>
                @endforeach
            </select>

            <label for="asignatura">Asignatura</label>
            <select id="asignatura" name="asignatura">
                <option value="">(Todos)</option>
                @foreach($asignaturas as $a)
                    <option value="{{ (int) $a->id }}" @selected((string)$asignatura === (string)$a->id)>{{ mb_strtoupper((string) $a->nombre) }}</option>
                @endforeach
            </select>

            <label for="periodo">Periodo</label>
            <select id="periodo" name="periodo">
                <option value="">(Todos)</option>
                @foreach($periodos as $p)
                    <option value="{{ (int) $p->id }}" @selected((string)$periodo === (string)$p->id)>{{ $p->periodo }}</option>
                @endforeach
            </select>

            <label for="grado">Grado</label>
            <select id="grado" name="grado">
                <option value="">(Todos)</option>
                @foreach($grados as $g)
                    <option value="{{ (int) $g->id }}" @selected((string)$grado === (string)$g->id)>{{ trim((string)$g->nombre) }}</option>
                @endforeach
            </select>

            <label for="nivel">Nivel de Calificación</label>
            <select id="nivel" name="nivel">
                <option value="">(Todos)</option>
                <option value="No Clasificado" @selected((string)$nivel === 'No Clasificado')>No Clasificado</option>
                @foreach($rangos as $r)
                    <option value="{{ (string) $r->nombre }}" @selected(\Illuminate\Support\Str::lower(\Illuminate\Support\Str::ascii((string)$nivel)) === \Illuminate\Support\Str::lower(\Illuminate\Support\Str::ascii((string)$r->nombre)) )>{{ mb_strtoupper((string)$r->nombre) }}</option>
                @endforeach
            </select>

            <button type="submit" class="btn-legacy">Buscar</button>
            <a href="#" class="btn-legacy" style="display:inline-flex;align-items:center;justify-content:center;text-decoration:none;">Agregar</a>
        </form>

        <div class="table-box">
            <div class="table-title ui-table-title">
                Logros
                <a class="tab-link {{ $estado === 'habilitados' ? 'active' : '' }}" href="{{ request()->fullUrlWithQuery(['estado' => 'habilitados', 'page' => 1]) }}">Habilitados</a>
                <a class="tab-link {{ $estado === 'deshabilitados' ? 'active' : '' }}" href="{{ request()->fullUrlWithQuery(['estado' => 'deshabilitados', 'page' => 1]) }}">Deshabilitados</a>
                <span class="pager-top">Ir a pag. {{ $rows->currentPage() }} / {{ $rows->lastPage() }}</span>
            </div>
            <table class="legacy-table ui-table">
                <thead>
                <tr>
                    <th style="width:28px;"><input type="checkbox"></th>
                    <th style="width:110px;">Grado</th>
                    <th style="width:220px;">Asignatura</th>
                    <th>Descripción</th>
                    <th style="width:70px;">Periodo</th>
                    <th style="width:130px;">Nivel de Calificación</th>
                </tr>
                </thead>
                <tbody>
                @forelse($rows as $r)
                    <tr>
                        <td><input type="checkbox"></td>
                        <td>{{ trim((string) $r->grado_nombre) }}</td>
                        <td>{{ mb_strtoupper((string) $r->asignatura_nombre) }}</td>
                        <td>
                            <a href="#" class="logro-link">{{ trim((string) $r->concepto) }}</a>
                            <div class="meta">
                                <span>Creado por: {{ $r->creado_por ?: 'N/A' }} ({{ $r->created_at ?: '-' }})</span>
                                <span>Modificado por: {{ $r->modificado_por ?: 'N/A' }} ({{ $r->updated_at ?: '-' }})</span>
                            </div>
                        </td>
                        <td>{{ $r->periodo_nombre ?: '-' }}</td>
                        <td>{{ $r->nivel_calificacion }}</td>
                    </tr>
                @empty
                    <tr><td colspan="6">Sin logros para los filtros aplicados.</td></tr>
                @endforelse
                </tbody>
            </table>
        </div>

        <div class="pager">
            @if($rows->onFirstPage())
                <span class="disabled">&laquo; Anterior</span>
            @else
                <a href="{{ $rows->previousPageUrl() }}">&laquo; Anterior</a>
            @endif

            @for($page = 1; $page <= $rows->lastPage(); $page++)
                @if($page === 1 || $page === $rows->lastPage() || ($page >= $rows->currentPage()-2 && $page <= $rows->currentPage()+2))
                    @if($page === $rows->currentPage())
                        <span class="active">{{ $page }}</span>
                    @else
                        <a href="{{ $rows->url($page) }}">{{ $page }}</a>
                    @endif
                @elseif($page === $rows->currentPage()-3 || $page === $rows->currentPage()+3)
                    <span>...</span>
                @endif
            @endfor

            @if($rows->hasMorePages())
                <a href="{{ $rows->nextPageUrl() }}">Siguiente &raquo;</a>
            @else
                <span class="disabled">Siguiente &raquo;</span>
            @endif
        </div>
    </div>
@endsection

