@extends('admin.layouts.app')

@section('title', 'Detalle de Estudiante')
@section('page_title', 'Detalle de Estudiante')

@section('content')
    @php
        $codigoView = 'WS-' . str_pad((string) ((int) ($student->contabilidad_id ?: $student->id)), 4, '0', STR_PAD_LEFT);
    @endphp
    <style>
        .detail-wrap { background:#efefef; border:1px solid #cdd5db; padding:14px; }
        .h-main { text-align:center; color:#035f7b; margin:8px 0 12px; font-size:34px; font-size:26px; font-weight:800; }
        .box { border:2px solid #0f708e; background:#fff; }
        .box-head { background:#0d6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .box-body { padding:14px; }
        .top-grid { display:grid; grid-template-columns: 1fr auto; gap:12px; align-items:center; }
        .top-actions { display:flex; align-items:center; gap:10px; justify-content:flex-end; }
        .btn-legacy {
            background:#d9a10c;
            border:1px solid #9a7205;
            color:#fff;
            font-weight:700;
            min-width:110px;
            width:auto;
            height:32px;
            border-radius:6px;
            cursor:pointer;
            padding:0 18px;
            display:inline-flex;
            align-items:center;
            justify-content:center;
            white-space:nowrap;
        }
        .meta { display:flex; gap:40px; margin-bottom:10px; }
        .meta strong { display:inline-block; min-width:180px; }
        .req { color:#d98b00; font-weight:700; }
        .section { border:1px solid #d1d7dc; background:#f8f8f8; padding:10px; margin-top:12px; }
        .section-title { margin:0 0 10px; color:#be8a07; font-weight:800; letter-spacing:6px; text-transform:uppercase; font-size:16px; }
        .grid-personal { display:grid; grid-template-columns: 1fr 1fr 220px; gap:16px; }
        .field { margin-bottom:8px; }
        .field label { display:block; font-weight:700; font-size:14px; margin-bottom:2px; }
        .field input, .field select { width:100%; height:30px; border:1px solid #0a7391; background:#d9e7e7; padding:4px 8px; }
        .photo-box { text-align:center; }
        .photo-box img, .photo-box .empty { width:210px; height:260px; border:1px solid #c1c8ce; object-fit:cover; background:#f0f0f0; margin:0 auto 8px; display:block; }
        .inline { display:flex; gap:8px; align-items:center; }
        .gender { display:flex; gap:18px; padding-top:4px; }
        .course-row { display:grid; grid-template-columns: 140px 260px; gap:10px; align-items:center; max-width:460px; }
        .course-row label { font-weight:700; }
        .family-note { background:#f6e8bf; border-top:1px solid #b4a378; border-bottom:1px solid #b4a378; padding:4px 8px; margin:10px 0 6px; font-style:italic; }
        .fam-table { width:100%; border-collapse:collapse; }
        .fam-table th, .fam-table td { border:1px solid #8fa2b2; padding:6px; font-size:14px; }
        .fam-table th { background:#cfd8e0; text-align:left; }
        .footer-actions { text-align:center; margin-top:14px; display:flex; justify-content:center; gap:18px; align-items:center; }
        .footer-actions .btn-legacy { flex:0 0 auto; }
        @media (max-width: 1080px) {
            .grid-personal { grid-template-columns:1fr; }
            .top-grid { grid-template-columns:1fr; }
            .meta { flex-direction:column; gap:8px; }
        }
    </style>

    <div class="detail-wrap">
        <h2 class="h-main">Detalle de Estudiante</h2>
        @if(session('status'))
            <div style="margin-bottom:10px;padding:8px 10px;background:#e7f7ea;border:1px solid #9dd5aa;color:#125323;">{{ session('status') }}</div>
        @endif
        @if ($errors->any())
            <div style="margin-bottom:10px;padding:8px 10px;background:#fff3f3;border:1px solid #efb0b0;color:#8b1f1f;">
                <strong>Revisa estos campos:</strong>
                <ul style="margin:6px 0 0 18px;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="box">
            <div class="box-head ui-box-head">Detalle de Estudiante</div>
            <div class="box-body">
                <form method="POST" action="{{ route('admin.estudiantes.update', ['id' => $student->id, 'annio' => $annio]) }}" enctype="multipart/form-data">
                    @csrf
                    <div class="top-grid">
                        <div class="meta">
                            <div><strong>Código</strong> {{ $codigoView }}</div>
                            <div><strong>No. Orden de Matrícula</strong> {{ $student->numero_mat ?: '-' }}</div>
                        </div>
                        <div class="top-actions">
                            <div style="text-align:right;color:#d98b00;font-style:italic;">* Requerido</div>
                            <button type="button" class="btn-legacy">Matrícula</button>
                            <button type="submit" class="btn-legacy">Guardar</button>
                        </div>
                    </div>

                    <div class="section">
                        <h3 class="section-title">Información Personal</h3>
                        <div class="grid-personal">
                            <div>
                                <div class="field">
                                    <label>Primer Nombre <span class="req">*</span></label>
                                    <input name="primer_nombre" value="{{ old('primer_nombre', $primerNombre) }}">
                                </div>
                                <div class="field">
                                    <label>Primer Apellido <span class="req">*</span></label>
                                    <input name="primer_apellido" value="{{ old('primer_apellido', $student->apellido1) }}">
                                </div>
                                <div class="field">
                                    <label>Fecha de Nacimiento</label>
                                    <input type="date" name="fecha_nac" value="{{ old('fecha_nac', $student->fecha_nac) }}">
                                </div>
                                <div class="field">
                                    <label>Tipo de Documento</label>
                                    <select name="tipo_dcto">
                                        @foreach(['Tarjeta de Identidad','Registro Civil','Cédula de Ciudadanía','Pasaporte'] as $docType)
                                            <option value="{{ $docType }}" @selected(old('tipo_dcto', $student->tipo_dcto) === $docType)>{{ $docType }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="field">
                                    <label>EPS</label>
                                    <input name="eps" value="{{ old('eps', $student->salud_eps) }}">
                                </div>
                                <div class="field">
                                    <label>Religión</label>
                                    <input name="religion" value="{{ old('religion', $student->religion) }}">
                                </div>
                            </div>

                            <div>
                                <div class="field">
                                    <label>Segundo Nombre</label>
                                    <input name="segundo_nombre" value="{{ old('segundo_nombre', $segundoNombre) }}">
                                </div>
                                <div class="field">
                                    <label>Segundo Apellido</label>
                                    <input name="segundo_apellido" value="{{ old('segundo_apellido', $student->apellido2) }}">
                                </div>
                                <div class="field">
                                    <label>Ciudad de Nacimiento</label>
                                    <input name="ciudad_nac" value="{{ old('ciudad_nac', $student->ciudad_nac) }}">
                                </div>
                                <div class="field">
                                    <label>No. de Documento <span class="req">*</span></label>
                                    <input name="documento" value="{{ old('documento', $student->documento) }}">
                                </div>
                                <div class="field">
                                    <label>Tipo de Sangre</label>
                                    <input name="tipo_sangre" value="{{ old('tipo_sangre', $student->grupo_sang) }}">
                                </div>
                                <div class="field">
                                    <label>Dirección Email</label>
                                    <input type="email" name="email" value="{{ old('email', $student->email) }}">
                                </div>
                                <div class="field">
                                    <label>Género</label>
                                    <div class="gender">
                                        <label><input type="radio" name="sexo" value="Masculino" @checked(old('sexo', $student->sexo) === 'Masculino')> Masculino</label>
                                        <label><input type="radio" name="sexo" value="Femenino" @checked(old('sexo', $student->sexo) === 'Femenino')> Femenino</label>
                                    </div>
                                </div>
                            </div>

                            <div class="photo-box">
                                @if(!empty($student->photo))
                                    <img src="{{ asset('storage/' . $student->photo) }}" alt="Foto estudiante">
                                @else
                                    <div class="empty"></div>
                                @endif
                                <div class="field" style="text-align:left;">
                                    <label>Foto</label>
                                    <input type="file" name="photo" accept=".jpg,.jpeg,.png">
                                </div>
                                <div class="field" style="text-align:left;">
                                    <label><input type="checkbox" name="is_habilitar_mat" value="1" @checked((int)old('is_habilitar_mat', $student->is_habilitar_mat) === 1)> Matrícula {{ $annio }} firmada</label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="section">
                        <h3 class="section-title">Información Académica</h3>
                        <div class="course-row">
                            <label>Curso año {{ $annio }}</label>
                            <select name="salon_id">
                                @foreach($allSalones as $salon)
                                    <option value="{{ $salon->id }}" @selected((int)old('salon_id', $student->salon_id) === (int)$salon->id)>
                                        {{ $salon->nombre }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="section">
                        <h3 class="section-title">Grupo Familiar</h3>
                        <div style="margin-bottom:8px;"><strong>Grupo Familiar actual:</strong> {{ $familyMembers->pluck('nombre')->join(', ') }}</div>
                        <div class="family-note">(Mostrando máximo 5 grupos familiares. Afine los criterios de búsqueda para obtener mejores resultados)</div>
                        <table class="fam-table">
                            <thead>
                                <tr>
                                    <th>Nombre</th>
                                    <th>Parentesco</th>
                                    <th>No. Documento</th>
                                    <th>Teléfono(s)</th>
                                    <th>Dirección Email</th>
                                    <th>Código</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($familyMembers as $m)
                                    <tr>
                                        <td>{{ $m['nombre'] }}</td>
                                        <td>{{ $m['parentesco'] }}</td>
                                        <td>{{ $m['documento'] ?: '-' }}</td>
                                        <td>{{ $m['telefono'] ?: '-' }}</td>
                                        <td>{{ $m['email'] ?: '-' }}</td>
                                        <td>{{ $m['codigo'] ?: 'N/A' }}</td>
                                    </tr>
                                @empty
                                    <tr><td colspan="6">Sin miembros familiares asociados.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="footer-actions">
                        <button type="submit" class="btn-legacy">Guardar</button>
                        <a href="{{ route('admin.estudiantes.index', ['annio' => $annio]) }}" class="btn-legacy" style="display:inline-flex;align-items:center;justify-content:center;text-decoration:none;">Regresar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

