<!doctype html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>{{ $tipo === 'calificaciones' ? 'Lista de Calificaciones' : 'Lista de Asistencia' }}</title>
    <style>
        @page {
            size: {{ $papel === 'Oficio' ? 'legal' : 'letter' }} portrait;
            margin: 14mm 11mm;
        }
        :root {
            --brand: #0b6d87;
            --brand-soft: #e8f1f4;
            --line: #7f8f98;
            --text: #202428;
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            color: var(--text);
            font-family: "Trebuchet MS", "Segoe UI", Arial, sans-serif;
            font-size: 11.5px;
        }
        .no-print { margin-bottom: 10px; }
        .btn {
            background: var(--brand);
            color: #fff;
            border: 0;
            border-radius: 4px;
            padding: 8px 12px;
            cursor: pointer;
            font-weight: 700;
        }
        .report {
            border: 1px solid #c9d3d8;
        }
        .header {
            border-bottom: 2px solid var(--brand);
            padding: 10px 12px 8px;
            background: linear-gradient(180deg, #f8fbfc 0%, #eef5f7 100%);
        }
        .brand {
            font-size: 12px;
            letter-spacing: 0.5px;
            color: #3c4e56;
            text-transform: uppercase;
            font-weight: 700;
        }
        .title {
            margin: 4px 0 0;
            font-size: 22px;
            line-height: 1.1;
            color: var(--brand);
            font-weight: 900;
        }
        .subtitle {
            margin-top: 2px;
            color: #5c6b73;
            font-weight: 600;
        }
        .meta-grid {
            padding: 10px 12px;
            display: grid;
            grid-template-columns: repeat(3, minmax(0, 1fr));
            gap: 6px 12px;
            border-bottom: 1px solid #d7e0e4;
            background: #fff;
        }
        .meta-item b { color: #0a4153; }
        .meta-item { white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .table-wrap { padding: 10px 12px; }
        table {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
        }
        th, td {
            border: 1px solid var(--line);
            padding: 5px 6px;
            vertical-align: middle;
        }
        th {
            background: var(--brand-soft);
            color: #143745;
            font-weight: 800;
            text-align: left;
        }
        tbody tr:nth-child(even) { background: #f8fbfc; }
        .center { text-align: center; }
        .muted { color: #6c7a80; }
        .footer {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 18px;
            padding: 18px 12px 12px;
        }
        .sign {
            border-top: 1px solid #6f7f87;
            padding-top: 5px;
            text-align: center;
            font-size: 11px;
            color: #3a464c;
        }
        .totals {
            padding: 0 12px 10px;
            text-align: right;
            font-weight: 700;
            color: #2f3d43;
        }
        .legacy-head {
            border: 1px solid #444;
            border-radius: 0;
            padding: 10px 12px;
            margin-bottom: 8px;
        }
        .legacy-title {
            text-align: center;
            font-size: 18px;
            margin: 0 0 8px;
            font-weight: 700;
            letter-spacing: 0;
            font-family: Arial, Helvetica, sans-serif;
        }
        .legacy-meta {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 4px 20px;
            font-size: 12px;
            font-family: Arial, Helvetica, sans-serif;
        }
        .legacy-meta .row {
            display: flex;
            gap: 6px;
            align-items: baseline;
        }
        .legacy-meta .row-right {
            display: flex;
            gap: 6px;
            justify-self: end;
            min-width: 180px;
        }
        .legacy-table th, .legacy-table td {
            border: 1px solid #222;
            padding: 2px 4px;
            font-size: 11px;
            font-family: Arial, Helvetica, sans-serif;
        }
        .legacy-table th {
            background: #e5e5e5;
            font-weight: 700;
        }
        .legacy-table td.blank { height: 22px; }
        .page-break {
            page-break-after: always;
            break-after: page;
            margin-bottom: 8px;
        }
        @media print {
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button class="btn" onclick="window.print()">Imprimir / Guardar PDF</button>
    </div>

    @if($tipo === 'calificaciones')
        @php($sheets = $teacherSheets ?? collect())
        @foreach($sheets as $sheet)
            <div class="{{ $loop->last ? '' : 'page-break' }}">
                <div class="legacy-head">
                    <h1 class="legacy-title">Lista de Estudiantes de Curso</h1>
                    <div class="legacy-meta">
                        <div class="row"><span>Curso:</span> <b>{{ $curso->nombre }}</b></div>
                        <div class="row"><span>Profesor:</span> <b>{{ $sheet->profesor ?: 'Todos' }}</b></div>
                        <div class="row-right"><span>Periodo:</span> <b>{{ $periodoLabel !== '' ? $periodoLabel : 'Todos' }}</b></div>
                        <div class="row"><span>Salon:</span> <b>{{ $curso->nombre }}</b></div>
                        <div class="row"><span>Asignatura:</span> <b>{{ $sheet->asignatura ?: 'TODAS' }}</b></div>
                        <div class="row-right"><span>Anio:</span> <b>{{ $annio }}</b></div>
                    </div>
                </div>

                <table class="legacy-table">
                    <thead>
                    <tr>
                        <th style="width:30px;" class="center">#</th>
                        <th>Nombre Estudiante</th>
                        @for($i = 1; $i <= 10; $i++)
                            <th style="width:42px;" class="center">{{ $i }}</th>
                        @endfor
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($students as $index => $s)
                        <tr>
                            <td class="center">{{ $index + 1 }}</td>
                            <td>{{ $s->nombre }}</td>
                            @for($i = 1; $i <= 10; $i++)
                                <td class="blank"></td>
                            @endfor
                        </tr>
                    @empty
                        <tr>
                            <td colspan="12" class="center muted">No hay estudiantes en este curso.</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        @endforeach
    @else
        @php($sheets = $teacherSheets ?? collect())
        @foreach($sheets as $sheet)
            <div class="{{ $loop->last ? '' : 'page-break' }}">
                <div class="legacy-head">
                    <h1 class="legacy-title">Lista de Estudiantes de Curso</h1>
                    <div class="legacy-meta">
                        <div class="row"><span>Curso:</span> <b>{{ $curso->nombre }}</b></div>
                        <div class="row"><span>Profesor:</span> <b>{{ $sheet->profesor ?: 'Todos' }}</b></div>
                        <div class="row-right"><span>Periodo:</span> <b>{{ $periodoLabel !== '' ? $periodoLabel : 'Todos' }}</b></div>
                        <div class="row"><span>Salon:</span> <b>{{ $curso->nombre }}</b></div>
                        <div class="row"><span>Asignatura:</span> <b>{{ $sheet->asignatura ?: 'TODAS' }}</b></div>
                        <div class="row-right"><span>Anio:</span> <b>{{ $annio }}</b></div>
                    </div>
                </div>

                <table class="legacy-table">
                    <thead>
                    <tr>
                        <th style="width:30px;" class="center">#</th>
                        <th>Nombre Estudiante</th>
                        @for($i = 1; $i <= 31; $i++)
                            <th style="width:14px; font-size:10px; padding:1px 0;" class="center">{{ $i }}</th>
                        @endfor
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($students as $index => $s)
                        <tr>
                            <td class="center">{{ $index + 1 }}</td>
                            <td>{{ $s->nombre }}</td>
                            @for($i = 1; $i <= 31; $i++)
                                <td class="blank"></td>
                            @endfor
                        </tr>
                    @empty
                        <tr>
                            <td colspan="33" class="center muted">No hay estudiantes en este curso.</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        @endforeach
    @endif
</body>
</html>
