@extends('admin.layouts.app')

@section('title', 'Grados')
@section('page_title', 'Grados')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:18px 14px 28px; }
        .legacy-title { text-align:center; color:#00607f; margin:8px 0 14px; font-weight:800; }
        .filters { max-width:1040px; margin:0 auto 12px; display:grid; grid-template-columns: 1fr 260px 200px 120px; gap:8px; align-items:center; }
        .filters input, .filters select {
            background:#d9e7e7; border:1px solid #08708e; border-radius:0; height:32px; padding:4px 8px;
        }
        .btn-legacy {
            display:inline-flex; align-items:center; justify-content:center;
            min-width:90px; height:32px; padding:0 14px;
            border-radius:6px; border:1px solid #9a7205;
            background:#d9a10c; color:#fff; font-weight:700; text-decoration:none;
            box-shadow:0 1px 0 rgba(255,255,255,.35) inset, 0 2px 6px rgba(0,0,0,.2);
            cursor: pointer;
        }
        .table-box { border:2px solid #0e7a96; background:#fff; max-width:1040px; margin:0 auto; }
        .table-title { background:#0e6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .legacy-table { width:100%; border-collapse:collapse; }
        .legacy-table th, .legacy-table td { border:1px solid #95a5ad; padding:5px 6px; font-size:14px; text-align:left; vertical-align:middle; }
        .legacy-table th { background:#d5dddd; font-weight:800; }
        .legacy-table tbody tr:nth-child(even) { background:#ccdbdd; }
        .legacy-table a { color:#005f84; text-decoration:underline; }
        .status-chip { display:inline-block; padding:2px 8px; border-radius:10px; font-size:12px; font-weight:700; }
        .status-active { background:#dff5e1; color:#0f6b2b; border:1px solid #8bca95; }
        .status-inactive { background:#ffe9e9; color:#8e2222; border:1px solid #efb0b0; }
        .icon-btn {
            width:28px; height:24px; border-radius:4px; cursor:pointer; line-height:1; padding:0; font-size:13px; font-weight:700;
            display:inline-flex; align-items:center; justify-content:center; text-decoration:none;
        }
        .btn-edit { border:1px solid #2b6a9a; color:#2b6a9a; background:#eef6ff; }
        .btn-delete { border:1px solid #9a2f2f; color:#9a2f2f; background:#fff2f2; }
        .total { max-width:1040px; margin:4px auto 0; text-align:right; font-size:13px; }
        .actions { text-align:center; margin-top:16px; display:flex; justify-content:center; gap:10px; }
        .msg-ok { max-width:1040px; margin:0 auto 10px; padding:8px 10px; background:#e7f7ea; border:1px solid #9dd5aa; color:#125323; }
        @media (max-width: 980px) {
            .filters { grid-template-columns: 1fr; }
        }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Grados</h2>
        @if(session('status'))
            <div class="msg-ok">{{ session('status') }}</div>
        @endif

        <form class="filters" method="GET">
            <input type="text" name="q" placeholder="Buscar por nombre o abreviatura" value="{{ $q }}">
            <select name="nivel">
                <option value="">(Todos los niveles)</option>
                @foreach($niveles as $n)
                    <option value="{{ $n->id }}" @selected((string)$nivel === (string)$n->id)>{{ $n->nombre }}</option>
                @endforeach
            </select>
            <select name="estado">
                <option value="activos" @selected($estado === 'activos')>Activos</option>
                <option value="inactivos" @selected($estado === 'inactivos')>Inactivos</option>
                <option value="todos" @selected($estado === 'todos')>Todos</option>
            </select>
            <button type="submit" class="btn-legacy">Buscar</button>
        </form>

        <div class="table-box">
            <div class="table-title ui-table-title">Grados</div>
            <table class="legacy-table ui-table">
                <thead>
                <tr>
                    <th style="width:38px;">E</th>
                    <th style="width:38px;">X</th>
                    <th style="width:80px;">Orden</th>
                    <th style="width:90px;">Abrev.</th>
                    <th>Grado</th>
                    <th style="width:220px;">Nivel</th>
                    <th style="width:120px;">Cursos</th>
                    <th style="width:120px;">Estado</th>
                </tr>
                </thead>
                <tbody>
                @forelse($rows as $r)
                    <tr>
                        <td style="text-align:center;">
                            <a class="icon-btn btn-edit" href="{{ route('admin.general.grados.show', ['id' => $r->id]) }}" title="Editar">&#9998;</a>
                        </td>
                        <td style="text-align:center;">
                            <button class="icon-btn btn-delete" type="button" title="Eliminar" onclick="deleteGrado({{ $r->id }})">&#128465;</button>
                        </td>
                        <td>{{ (int) $r->orden }}</td>
                        <td>{{ $r->abrev }}</td>
                        <td><a href="{{ route('admin.general.grados.show', ['id' => $r->id]) }}">{{ $r->nombre }}</a></td>
                        <td>{{ $r->nivel }}</td>
                        <td>{{ (int) $r->cursos_count }}</td>
                        <td>
                            @if((int)$r->is_active === 1)
                                <span class="status-chip status-active">Activo</span>
                            @else
                                <span class="status-chip status-inactive">Inactivo</span>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr><td colspan="8">Sin grados registrados.</td></tr>
                @endforelse
                </tbody>
            </table>
        </div>
        <div class="total ui-total">Total registros: {{ $rows->count() }}</div>
        <div class="actions">
            <a href="{{ route('admin.general.grados.create') }}" class="btn-legacy">Agregar</a>
        </div>
    </div>

    <form id="delete-grado-form" method="POST" action="" style="display:none;">
        @csrf
    </form>

    <script>
        function deleteGrado(id) {
            if (!window.confirm('¿Seguro que deseas eliminar este grado?')) return;
            const form = document.getElementById('delete-grado-form');
            form.action = "{{ url('/admin/general/grados/detalle') }}/" + id + "/eliminar";
            form.submit();
        }
    </script>
@endsection

