@extends('admin.layouts.app')

@section('title', 'Acudientes')
@section('page_title', 'Acudientes')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:18px 14px 28px; }
        .legacy-title { text-align:center; color:#00607f; font-size:38px; margin:8px 0 14px; font-weight:800; }
        .filters { max-width: 1060px; margin: 0 auto 8px; }
        .row { display:grid; grid-template-columns: 140px 1fr 130px 1fr auto auto; gap:10px; align-items:center; margin-bottom:10px; }
        .row-2 { display:grid; grid-template-columns: 140px 140px; gap:10px; align-items:center; margin-bottom:10px; }
        label { font-weight:700; font-size:15px; }
        input { background:#d9e7e7; border:1px solid #08708e; border-radius:0; height:30px; padding:4px 8px; width:100%; }
        .btn-legacy {
            background:#d9a10c; border:1px solid #9a7205; color:#fff; font-weight:700;
            min-width:110px; height:32px; border-radius:6px; cursor:pointer; padding:0 16px;
            box-shadow:0 1px 0 rgba(255,255,255,.35) inset, 0 2px 6px rgba(0,0,0,.2);
        }
        .table-box { border:2px solid #0e7a96; background:#fff; max-width:1060px; margin:0 auto; }
        .table-title { background:#0e6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .legacy-table { width:100%; border-collapse:collapse; }
        .legacy-table th, .legacy-table td { border:1px solid #95a5ad; padding:5px 6px; font-size:15px; text-align:left; vertical-align:middle; }
        .legacy-table th { background:#d5dddd; font-weight:800; }
        .legacy-table tbody tr:nth-child(even) { background:#ccdbdd; }
        .legacy-table a { color:#005f84; text-decoration:underline; }
        .pager { margin: 10px auto 0; max-width:1060px; display:flex; justify-content:center; gap:6px; flex-wrap:wrap; }
        .pager a, .pager span {
            border:1px solid #8da0ad; background:#fff; color:#0e2b3d; text-decoration:none;
            padding:4px 9px; border-radius:4px; font-size:13px; line-height:1.2;
        }
        .pager .active { background:#0e6f88; border-color:#0e6f88; color:#fff; font-weight:700; }
        .pager .disabled { opacity:.45; pointer-events:none; }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Acudientes</h2>

        <form class="filters" method="GET">
            <input type="hidden" name="annio" value="{{ $annio }}">
            <div class="row">
                <label for="nombres">Nombres/Apellidos</label>
                <input id="nombres" name="nombres" value="{{ $nombres }}">
                <label for="documento">No. de Documento</label>
                <input id="documento" name="documento" value="{{ $documento }}">
                <button type="submit" class="btn-legacy">Buscar</button>
                <button type="button" class="btn-legacy">Agregar</button>
            </div>
            <div class="row-2">
                <label for="codigo_estudiante">Código Estudiante</label>
                <input id="codigo_estudiante" name="codigo_estudiante" value="{{ $codigoEstudiante }}">
            </div>
        </form>

        <div class="table-box">
            <div class="table-title ui-table-title">Acudientes</div>
            <table class="legacy-table ui-table">
                <thead>
                <tr>
                    <th style="width:70px;">ID</th>
                    <th>Nombre</th>
                    <th style="width:160px;">No. de Documento</th>
                    <th style="width:170px;">Telefono(s)</th>
                    <th style="width:260px;">Dirección Email</th>
                    <th style="width:120px;">Saldo Pendiente</th>
                </tr>
                </thead>
                <tbody>
                @forelse($rows as $r)
                    <tr>
                        <td>{{ (int) $r->id }}</td>
                        <td><a href="{{ route('admin.general.acudientes.show', ['id' => $r->id, 'annio' => $annio]) }}">{{ $r->nombre }}</a></td>
                        <td>{{ $r->documento }}</td>
                        <td>{{ $r->telefono }}</td>
                        <td>{{ $r->email }}</td>
                        <td>{{ (int) $r->is_deudor === 1 ? 'Pendiente' : '$ 0' }}</td>
                    </tr>
                @empty
                    <tr><td colspan="6">Sin acudientes para los filtros aplicados.</td></tr>
                @endforelse
                </tbody>
            </table>
        </div>

        <div class="pager">
            @if($rows->onFirstPage())
                <span class="disabled">&laquo; Anterior</span>
            @else
                <a href="{{ $rows->previousPageUrl() }}">&laquo; Anterior</a>
            @endif

            @for($page = 1; $page <= $rows->lastPage(); $page++)
                @if(
                    $page === 1 ||
                    $page === $rows->lastPage() ||
                    ($page >= $rows->currentPage() - 2 && $page <= $rows->currentPage() + 2)
                )
                    @if($page === $rows->currentPage())
                        <span class="active">{{ $page }}</span>
                    @else
                        <a href="{{ $rows->url($page) }}">{{ $page }}</a>
                    @endif
                @elseif(
                    $page === $rows->currentPage() - 3 ||
                    $page === $rows->currentPage() + 3
                )
                    <span>...</span>
                @endif
            @endfor

            @if($rows->hasMorePages())
                <a href="{{ $rows->nextPageUrl() }}">Siguiente &raquo;</a>
            @else
                <span class="disabled">Siguiente &raquo;</span>
            @endif
        </div>
    </div>
@endsection

