@extends('admin.layouts.app')

@section('title', 'Notas')
@section('page_title', 'Notas')

@section('content')
    <div class="panel">
        <form class="toolbar" method="GET">
            <label for="annio">Año</label>
            <select id="annio" name="annio">
                @foreach($anios as $a)
                    <option value="{{ $a }}" @selected((int)$a === (int)$annio)>{{ $a }}</option>
                @endforeach
            </select>
            <button type="submit">Aplicar</button>
        </form>

        <table>
            <thead>
            <tr>
                <th>ID</th>
                <th>Año</th>
                <th>Período</th>
                <th>Estudiante</th>
                <th>Asignatura</th>
                <th>Nota Final</th>
                <th>Definitiva</th>
                <th>Plan Apoyo</th>
            </tr>
            </thead>
            <tbody>
            @forelse($rows as $r)
                <tr>
                    <td>{{ $r->id }}</td>
                    <td>{{ $r->annio }}</td>
                    <td>{{ $r->periodo_id }}</td>
                    <td>{{ trim($r->estudiante) }}</td>
                    <td>{{ $r->asignatura_id }}</td>
                    <td>{{ $r->nota_final }}</td>
                    <td>{{ $r->definitiva }}</td>
                    <td>{{ $r->plan_apoyo }}</td>
                </tr>
            @empty
                <tr><td colspan="8">Sin registros para el año seleccionado.</td></tr>
            @endforelse
            </tbody>
        </table>

        <div class="pagination">{{ $rows->links('pagination::bootstrap-4') }}</div>
    </div>
@endsection
