@extends('admin.layouts.app')

@section('title', $title)
@section('page_title', $title)

@section('content')
    <style>
        .obs-wrap { background:#efefef; border:1px solid #d0d0d0; padding:14px; max-width:980px; margin:0 auto; }
        .obs-title { margin:0 0 12px; color:#00607f; font-size:var(--fs-title-global); font-weight:800; text-align:center; }
        .obs-form { border:1px solid #9fb0b8; background:#f8fcfe; padding:10px; }
        .obs-grid { display:grid; grid-template-columns:160px 1fr; gap:8px; align-items:center; }
        .obs-grid textarea { min-height:140px; resize:vertical; }
        .obs-actions { margin-top:10px; text-align:right; }
        .obs-btn {
            border:1px solid #0e6f88; background:#0b7285; color:#fff;
            font-size:var(--fs-button-global); font-weight:700; padding:6px 12px; text-decoration:none; display:inline-block;
        }
    </style>

    <div class="obs-wrap">
        <h2 class="obs-title">Editar Observación General</h2>
        <div style="margin-bottom:10px;">
            <a href="{{ route('admin.observador.observaciones.index', ['annio' => (int) $obs->annio]) }}" class="obs-btn" style="background:#7a8c99;border-color:#5e707d;">Regresar</a>
        </div>
        <form method="POST" action="{{ route('admin.observador.observaciones.update', ['id' => (int) $obs->id]) }}" class="obs-form" enctype="multipart/form-data">
            @csrf
            <div class="obs-grid">
                <label><strong>Tipo</strong></label>
                <select name="tipo_reg" required>
                    <option value="ACAD" @selected((string)$obs->tipo_reg === 'ACAD')>Académico</option>
                    <option value="DISC" @selected((string)$obs->tipo_reg === 'DISC')>Disciplinario</option>
                </select>

                <label><strong>Año</strong></label>
                <input type="number" name="annio" value="{{ (int) $obs->annio }}" min="2000" max="2100" required>

                <label><strong>Periodo</strong></label>
                <select name="periodo_id" required>
                    @foreach($periodos as $p)
                        <option value="{{ (int) $p->id }}" @selected((int)$obs->periodo_id === (int)$p->id)>
                            {{ trim((string) ($p->label ?: $p->periodo)) }}
                        </option>
                    @endforeach
                </select>

                <label><strong>Fecha</strong></label>
                <input type="date" name="fecha" value="{{ (string) $obs->fecha }}" required>

                <label><strong>Estudiante</strong></label>
                <select name="estudiante_id" required>
                    @foreach($students as $s)
                        <option value="{{ (int) $s->id }}" @selected((int)$obs->estudiante_id === (int)$s->id)>
                            {{ $s->full_name }} {{ $s->salon !== '' ? ('- '.$s->salon) : '' }} [{{ $s->contabilidad_id ?: $s->id }}]
                        </option>
                    @endforeach
                </select>

                <label><strong>Observación</strong></label>
                <textarea name="asunto" required>{{ trim((string) $obs->asunto) }}</textarea>

                <label><strong>Evidencia</strong></label>
                <div>
                    @if(!empty($obs->foto_acudiente))
                        <a href="{{ asset($obs->foto_acudiente) }}" target="_blank">Ver archivo actual</a><br>
                    @endif
                    <input type="file" name="evidencia" accept=".jpg,.jpeg,.png,.pdf">
                </div>

            </div>
            <div class="obs-actions">
                <button type="submit" class="obs-btn" style="background:#d9a106;border-color:#9a7300;">Guardar cambios</button>
            </div>
        </form>
    </div>
@endsection
