﻿<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Colegio Windsor</title>
    <style>
        :root {
            --bg: #eef3ef;
            --left-bg: #dbe8db;
            --left-ring: #c8dcc7;
            --ink: #0f172a;
            --muted: #5f6f7f;
            --line: #d5dce3;
            --brand: #1bcf00;
            --brand-dark: #16a700;
            --panel: #ffffff;
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            min-height: 100vh;
            background: var(--bg);
            font-family: "Segoe UI", Tahoma, sans-serif;
            color: var(--ink);
        }
        .login-shell {
            min-height: 100vh;
            display: grid;
            grid-template-columns: 1.2fr 1fr;
        }
        .left-panel {
            position: relative;
            overflow: hidden;
            background: var(--left-bg);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 56px 36px;
        }
        .ring,
        .ring-2 {
            position: absolute;
            border-radius: 50%;
            pointer-events: none;
        }
        .ring {
            width: 640px;
            height: 640px;
            left: -180px;
            top: 50%;
            transform: translateY(-50%);
            border: 72px solid var(--left-ring);
            opacity: .9;
        }
        .ring-2 {
            width: 520px;
            height: 520px;
            left: -120px;
            top: 50%;
            transform: translateY(-50%);
            border: 54px solid #d3e3d2;
            opacity: .95;
        }
        .left-content {
            position: relative;
            max-width: 520px;
            z-index: 2;
        }
        .badge {
            width: 52px;
            height: 52px;
            border-radius: 14px;
            background: linear-gradient(135deg, #1ed700, #14b400);
            box-shadow: 0 10px 24px rgba(22, 167, 0, 0.25);
            display: grid;
            place-items: center;
            color: #fff;
            font-size: 22px;
            margin-bottom: 20px;
        }
        .left-title {
            margin: 0;
            font-size: clamp(28px, 2.8vw, 46px);
            line-height: 1.08;
            font-weight: 800;
            letter-spacing: -0.02em;
        }
        .left-title .accent { color: var(--brand-dark); }
        .left-sub {
            margin: 16px 0 0;
            max-width: 540px;
            color: #516171;
            font-size: 15px;
            line-height: 1.5;
        }
        .right-panel {
            background: var(--panel);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 40px 28px;
        }
        .login-box {
            width: min(500px, 95%);
        }
        .title {
            margin: 0 0 6px;
            font-size: clamp(30px, 2.6vw, 42px);
            line-height: 1.05;
            letter-spacing: -0.02em;
            font-weight: 800;
        }
        .sub {
            margin: 0 0 22px;
            color: var(--muted);
            font-size: 16px;
        }
        .notice {
            margin: 0 0 24px;
            padding: 12px 14px;
            border-radius: 12px;
            border: 1px solid #b5e6b0;
            background: #ebf9e9;
            color: #2f5f2a;
            font-size: 14px;
            line-height: 1.45;
        }
        .notice b { color: #19aa0d; }
        .error {
            background: #fff2f2;
            border: 1px solid #ffd6d6;
            color: #a62f2f;
            padding: 12px 14px;
            border-radius: 12px;
            margin-bottom: 14px;
            font-size: 16px;
        }
        .field { margin-bottom: 18px; }
        .field-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 8px;
        }
        label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            color: #253446;
        }
        .helper-link {
            font-size: 13px;
            color: #15ab09;
            text-decoration: none;
            font-weight: 600;
        }
        .input-wrap {
            position: relative;
        }
        input {
            width: 100%;
            border: 1px solid #d0d9e2;
            border-radius: 14px;
            padding: 11px 13px;
            font-size: 14px;
            color: #1f2f42;
            outline: none;
            transition: border-color .15s ease, box-shadow .15s ease;
            background: #fff;
        }
        input:focus {
            border-color: #8ecf83;
            box-shadow: 0 0 0 3px rgba(27, 207, 0, 0.15);
        }
        .pwd-toggle {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            border: 0;
            background: transparent;
            color: #93a0ad;
            cursor: pointer;
            padding: 4px;
            width: auto;
            margin: 0;
            box-shadow: none;
        }
        .submit-btn {
            width: 100%;
            border: 0;
            border-radius: 14px;
            padding: 11px 16px;
            background: linear-gradient(180deg, #21df00, #17be00);
            color: #fff;
            font-weight: 700;
            font-size: 15px;
            cursor: pointer;
            box-shadow: 0 10px 26px rgba(31, 181, 0, 0.28);
            transition: transform .12s ease, box-shadow .12s ease;
        }
        .submit-btn:hover { transform: translateY(-1px); box-shadow: 0 12px 28px rgba(31, 181, 0, 0.34); }
        .hint {
            margin-top: 20px;
            color: #6a7a8b;
            font-size: 13px;
            text-align: center;
        }
        .hint a {
            color: #17af0b;
            text-decoration: none;
            font-weight: 700;
        }
        @media (max-width: 1200px) {
            .login-shell { grid-template-columns: 1fr; }
            .left-panel { min-height: 300px; }
            .left-title { font-size: clamp(34px, 6vw, 52px); }
            .left-sub { font-size: 18px; }
            .right-panel { padding-top: 26px; }
        }
        @media (max-width: 640px) {
            .left-panel { padding: 34px 20px; }
            .right-panel { padding: 24px 14px; }
            .title { font-size: 34px; }
            .sub { font-size: 16px; }
            .notice { font-size: 14px; }
            label, input, .submit-btn { font-size: 16px; }
        }
    </style>
</head>
<body>
<div class="login-shell">
    <section class="left-panel">
        <div class="ring"></div>
        <div class="ring-2"></div>
        <div class="left-content">
            <div class="badge">👥</div>
            <h1 class="left-title">
                Software de Gestión Académica<br>
                <span class="accent">Colegio Windsor.</span>
            </h1>
            <p class="left-sub">
                
            </p>
        </div>
    </section>

    <section class="right-panel">
        <form class="login-box" method="POST" action="{{ route('login.attempt') }}">
            @csrf
            <h5 class="title">Iniciar Sesi&oacute;n</h5>
            <p class="sub">Ingresa tus credenciales para acceder al panel.</p>

            <div class="notice">
                <b>&iquest;Primera vez?</b> Bienvenido al portal del Colegio Windsor.
            </div>

            @if ($errors->any())
                <div class="error">{{ $errors->first() }}</div>
            @endif

            <div class="field">
                <label for="username">Usuario</label>
                <input id="username" name="username" type="text" value="{{ old('username') }}" placeholder="Ej. docente" required>
            </div>

            <div class="field">
                <div class="field-row">
                    <label for="password">Contrase&ntilde;a</label>
                    <a href="#" class="helper-link">&iquest;Olvidaste tu clave?</a>
                </div>
                <div class="input-wrap">
                    <input id="password" name="password" type="password" required>
                    <button type="button" class="pwd-toggle" id="togglePwd" aria-label="Mostrar contrase&ntilde;a">👁</button>
                </div>
            </div>

            <button type="submit" class="submit-btn">Ingresar al Portal →</button>
            <div class="hint">
                &iquest;Tienes problemas para ingresar?<br>
                <a href="mailto:soporte@windsorschool.edu.co">Contactar Soporte T&eacute;cnico</a>
            </div>
        </form>
    </section>
</div>
<script>
    (function () {
        var btn = document.getElementById('togglePwd');
        var pwd = document.getElementById('password');
        if (!btn || !pwd) return;
        btn.addEventListener('click', function () {
            pwd.type = pwd.type === 'password' ? 'text' : 'password';
        });
    })();
</script>
</body>
</html>
