<?php

use App\Http\Controllers\Admin\CarteraController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\EstudiantesController;
use App\Http\Controllers\Admin\NotasController;
use App\Http\Controllers\Admin\ProfesoresController;
use App\Http\Controllers\Admin\SectionController;
use App\Http\Controllers\AuthController;
use Illuminate\Support\Facades\Route;

Route::redirect('/', '/admin/dashboard');

Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.attempt');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::middleware('admin.auth')->prefix('admin')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('/estudiantes', [EstudiantesController::class, 'index'])->name('admin.estudiantes.index');
    Route::get('/estudiantes/{id}', [EstudiantesController::class, 'show'])->name('admin.estudiantes.show');
    Route::post('/estudiantes/{id}', [EstudiantesController::class, 'update'])->name('admin.estudiantes.update');
    Route::get('/profesores', [ProfesoresController::class, 'index'])->name('admin.profesores.index');
    Route::get('/profesores/nuevo', [ProfesoresController::class, 'create'])->name('admin.profesores.create');
    Route::post('/profesores/nuevo', [ProfesoresController::class, 'store'])->name('admin.profesores.store');
    Route::get('/profesores/{id}', [ProfesoresController::class, 'show'])->name('admin.profesores.show');
    Route::post('/profesores/{id}', [ProfesoresController::class, 'update'])->name('admin.profesores.update');
    Route::get('/notas', [NotasController::class, 'index'])->name('admin.notas.index');
    Route::get('/cartera', [CarteraController::class, 'index'])->name('admin.cartera.index');
    Route::get('/general/{item}', [SectionController::class, 'showGeneralItem'])->name('admin.general.item');
    Route::get('/general/grupos-familiares/{item}', [SectionController::class, 'showGeneralGruposItem'])->name('admin.general.grupos.item');
    Route::get('/general/acudientes/{id}', [SectionController::class, 'showGeneralAcudienteDetalle'])->name('admin.general.acudientes.show');
    Route::post('/general/acudientes/{id}', [SectionController::class, 'updateGeneralAcudienteDetalle'])->name('admin.general.acudientes.update');
    Route::get('/general/cursos/nuevo', [SectionController::class, 'createGeneralCurso'])->name('admin.general.cursos.create');
    Route::post('/general/cursos/nuevo', [SectionController::class, 'storeGeneralCurso'])->name('admin.general.cursos.store');
    Route::get('/general/cursos/detalle/{id}', [SectionController::class, 'showGeneralCursoDetalle'])->name('admin.general.cursos.show');
    Route::post('/general/cursos/detalle/{id}', [SectionController::class, 'updateGeneralCursoDetalle'])->name('admin.general.cursos.update');
    Route::get('/general/grados/nuevo', [SectionController::class, 'createGeneralGrado'])->name('admin.general.grados.create');
    Route::post('/general/grados/nuevo', [SectionController::class, 'storeGeneralGrado'])->name('admin.general.grados.store');
    Route::get('/general/grados/detalle/{id}', [SectionController::class, 'showGeneralGradoDetalle'])->name('admin.general.grados.show');
    Route::post('/general/grados/detalle/{id}', [SectionController::class, 'updateGeneralGradoDetalle'])->name('admin.general.grados.update');
    Route::post('/general/grados/detalle/{id}/eliminar', [SectionController::class, 'deleteGeneralGrado'])->name('admin.general.grados.delete');
    Route::get('/general/grados/{item}', [SectionController::class, 'showGeneralGradosItem'])->name('admin.general.grados.item');
    Route::get('/general/cursos/{item}', [SectionController::class, 'showGeneralCursosItem'])->name('admin.general.cursos.item');
    Route::get('/general/cursos/imprimir/{tipo}', [SectionController::class, 'printListaCurso'])->name('admin.general.cursos.print');
    Route::get('/academia/{item}', [SectionController::class, 'showAcademiaItem'])->name('admin.academia.item');
    Route::get('/calificaciones/niveles/nuevo', [SectionController::class, 'createNivelCalificacion'])->name('admin.calificaciones.niveles.create');
    Route::post('/calificaciones/niveles/nuevo', [SectionController::class, 'storeNivelCalificacion'])->name('admin.calificaciones.niveles.store');
    Route::get('/calificaciones/niveles/{id}', [SectionController::class, 'showNivelCalificacion'])->whereNumber('id')->name('admin.calificaciones.niveles.show');
    Route::post('/calificaciones/niveles/{id}', [SectionController::class, 'updateNivelCalificacion'])->whereNumber('id')->name('admin.calificaciones.niveles.update');
    Route::post('/calificaciones/niveles/agregar', [SectionController::class, 'addNivelCalificacion'])->name('admin.calificaciones.niveles.add');
    Route::post('/calificaciones/niveles/{id}/editar', [SectionController::class, 'editNivelCalificacion'])->name('admin.calificaciones.niveles.edit');
    Route::post('/calificaciones/niveles/{id}/eliminar', [SectionController::class, 'deleteNivelCalificacion'])->name('admin.calificaciones.niveles.delete');
    Route::post('/calificaciones/periodos-notas', [SectionController::class, 'savePeriodosNotas'])->name('admin.calificaciones.periodos_notas.save');
    Route::post('/calificaciones/periodos-notas/{id}/toggle', [SectionController::class, 'togglePeriodoNotas'])->name('admin.calificaciones.periodos_notas.toggle');
    Route::get('/calificaciones/{item}', [SectionController::class, 'showCalificacionesItem'])->name('admin.calificaciones.item');
    Route::get('/academia/asignacion-academica/{item}', [SectionController::class, 'showAcademiaAsignacionItem'])->name('admin.academia.asignacion.item');
    Route::post('/academia/asignacion-academica/por-curso', [SectionController::class, 'saveAsignacionPorCurso'])->name('admin.academia.asignacion.curso.save');
    Route::post('/academia/asignacion-academica/por-profesor-asignatura', [SectionController::class, 'saveAsignacionPorProfesorAsignatura'])->name('admin.academia.asignacion.profesor_asignatura.save');
    Route::post('/academia/asignacion-academica/indicadores', [SectionController::class, 'storeAsignacionIndicador'])->name('admin.academia.asignacion.indicadores.store');
    Route::post('/academia/asignacion-academica/indicadores/{id}', [SectionController::class, 'updateAsignacionIndicador'])->name('admin.academia.asignacion.indicadores.update');
    Route::post('/academia/periodos-academicos', [SectionController::class, 'savePeriodosAcademicos'])->name('admin.academia.periodos.save');
    Route::post('/academia/periodos-academicos/agregar', [SectionController::class, 'addPeriodoAcademico'])->name('admin.academia.periodos.add');
    Route::post('/academia/periodos-academicos/{numero}/editar', [SectionController::class, 'editPeriodoAcademico'])->name('admin.academia.periodos.edit');
    Route::post('/academia/periodos-academicos/{numero}/eliminar', [SectionController::class, 'deletePeriodoAcademico'])->name('admin.academia.periodos.delete');
    Route::post('/academia/areas-academicas/agregar', [SectionController::class, 'addAreaAcademica'])->name('admin.academia.areas.add');
    Route::get('/academia/areas-academicas/nuevo', [SectionController::class, 'createAreaAcademica'])->name('admin.academia.areas.create');
    Route::get('/academia/areas-academicas/{id}', [SectionController::class, 'showAreaAcademica'])->name('admin.academia.areas.show');
    Route::post('/academia/areas-academicas/{id}', [SectionController::class, 'updateAreaAcademica'])->name('admin.academia.areas.update');
    Route::post('/academia/areas-academicas/{id}/asignaturas/agregar', [SectionController::class, 'attachAsignaturaArea'])->name('admin.academia.areas.asignaturas.add');
    Route::post('/academia/areas-academicas/{id}/asignaturas/{asignaturaId}/quitar', [SectionController::class, 'detachAsignaturaArea'])->name('admin.academia.areas.asignaturas.remove');
    Route::post('/academia/areas-academicas/{id}/editar', [SectionController::class, 'editAreaAcademica'])->name('admin.academia.areas.edit');
    Route::post('/academia/areas-academicas/{id}/eliminar', [SectionController::class, 'deleteAreaAcademica'])->name('admin.academia.areas.delete');
    Route::get('/academia/asignaturas/nuevo', [SectionController::class, 'createAsignatura'])->name('admin.academia.asignaturas.create');
    Route::post('/academia/asignaturas/nuevo', [SectionController::class, 'storeAsignatura'])->name('admin.academia.asignaturas.store');
    Route::get('/academia/asignaturas/{id}', [SectionController::class, 'showAsignatura'])->name('admin.academia.asignaturas.show');
    Route::post('/academia/asignaturas/{id}', [SectionController::class, 'updateAsignatura'])->name('admin.academia.asignaturas.update');
    Route::post('/academia/asignaturas/{id}/eliminar', [SectionController::class, 'deleteAsignatura'])->name('admin.academia.asignaturas.delete');
    Route::get('/observador/observaciones-generales', [SectionController::class, 'showObservacionesGenerales'])->name('admin.observador.observaciones.index');
    Route::post('/observador/observaciones-generales', [SectionController::class, 'storeObservacionGeneral'])->name('admin.observador.observaciones.store');
    Route::get('/observador/observaciones-generales/{id}/editar', [SectionController::class, 'editObservacionGeneral'])->name('admin.observador.observaciones.edit');
    Route::post('/observador/observaciones-generales/{id}/editar', [SectionController::class, 'updateObservacionGeneral'])->name('admin.observador.observaciones.update');
    Route::post('/observador/observaciones-generales/{id}/eliminar', [SectionController::class, 'deleteObservacionGeneral'])->name('admin.observador.observaciones.delete');
    Route::get('/observador/registro-academico', [SectionController::class, 'showRegistroAcademico'])->name('admin.observador.registro_academico.index');
    Route::post('/observador/registro-academico', [SectionController::class, 'storeRegistroAcademico'])->name('admin.observador.registro_academico.store');
    Route::get('/observador/registro-academico/{id}/editar', [SectionController::class, 'editRegistroAcademico'])->name('admin.observador.registro_academico.edit');
    Route::post('/observador/registro-academico/{id}/editar', [SectionController::class, 'updateRegistroAcademico'])->name('admin.observador.registro_academico.update');
    Route::post('/observador/registro-academico/{id}/eliminar', [SectionController::class, 'deleteRegistroAcademico'])->name('admin.observador.registro_academico.delete');
    Route::get('/section/{section}', [SectionController::class, 'show'])->name('admin.section');
});
